# Fuzzy Config Key Provider

Another storage method uses Drupal’s _hash_salt_ as an encryption key.

The _hash_salt_ is already used as a secure key for generating one-time links,
hashing passwords, and other security-critical operations. It can also be
protected from being stored directly in `settings.php`.

If the _hash_salt_ were ever compromised, the entire site’s security would be
at risk. Because it is such a critical and trusted secret, it can also serve as
a secure basis for encrypting stored data.

This module extends the functionality of the [Key](https://www.drupal.org/project/key)
module. For more details, see issue [#3028014](https://www.drupal.org/project/key/issues/3028014)

For a full description of the module, visit the
[project page](https://www.drupal.org/project/fuzzy_key_provider).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/fuzzy_key_provider).


## Requirements

This module requires the following modules:

- [Key](https://www.drupal.org/project/key)


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Enable the module at Administration > Extend.
1. Got to Configuration > System > Keys to manage your keys.
1. Select "Fuzzy configuration" as a provider in your key configuration form.


## Maintainers

- Pedro Pelaez - [_psf](https://www.drupal.org/u/psf_)
- Frank Mably - [mably](https://www.drupal.org/u/mably)
