<?php
/**
 * @file
 * Our Google Authenticator login class.
 */
include_once("ga4php.php");

/*
 * Our Google Authenticator login class.
 */
class ga_loginGA extends GoogleAuthenticator {

  /*
   * Load data associated with a user.
   */
  function getData($username) {
    $result = db_select('ga_login')
      ->fields('ga_login', array('keydata'))
      ->condition('name', $username)
      ->execute()
      ->fetchAssoc();

    // check the result.
    if (!$result) {
      return FALSE;
    }

    return $result["keydata"];
  }

  /*
   * Save data associated with a user.
   */
  function putData($username, $data) {
    $result = db_merge('ga_login')
      ->key(array('name' => $username))
      ->fields(array('keydata' => $data))
      ->execute();

    if ($result) {
      return TRUE;
    }
    else {
      return FALSE;
    }
  }

  /*
   * Not used.
   */
  function getUsers() {
    // abstract function from base class.
  }

  /*
   * Create empty data.
   */
  function createEmptyData() {
    $data = parent::createEmptyData();
    $data["tokentype"] = "TOTP";
    return $data;
  }

}
