<?php

namespace Drupal\userpoints;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of User points type entities.
 */
class UserPointsTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('User points type');
    $header['initial_value'] = $this->t('Initial value');
    $header['id'] = $this->t('Machine name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    $row['label'] = $entity->label();
    $row['initial_value'] = $entity->get('initial_value');
    $row['id'] = $entity->id();

    return $row + parent::buildRow($entity);
  }

}
