<?php

namespace Drupal\gamify\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\user\UserInterface;

/**
 * Provides an event for when a user account gets canceled.
 *
 * @package Drupal\gamify\Event
 */
class RecentLogs extends Event {

  /**
   * The user account.
   *
   * @var \Drupal\user\UserInterface
   */
  protected UserInterface $user;

  /**
   * When the period since last run begins.
   *
   * @var int
   */
  protected int $lastRun;

  /**
   * The object to collect data during the process.
   *
   * @var array
   */
  protected array $result;

  /**
   * Constructs the object.
   *
   * @param \Drupal\user\UserInterface $user
   *   The account of the user logged in.
   * @param int $last_run
   *   When the period since last run begins.
   * @param array $result
   *   The results to pass through to condition and action.
   */
  public function __construct(UserInterface $user, int $last_run, array $result) {
    $this->user = $user;
    $this->lastRun = $last_run;
    $this->result = $result;
  }

  /**
   * Get the handled user.
   *
   * @return UserInterface
   *   Returns the handled usr.
   */
  public function getUser(): UserInterface {
    return $this->user;
  }

  /**
   * Get the last run time.
   *
   * @return int
   *   Returns timestamp when the period since last run begins.
   */
  public function getLastRun(): int {
    return $this->lastRun;
  }

  /**
   * Get the last run time.
   *
   * @return array
   *   Returns timestamp when the period since last run begins.
   */
  public function getRecentLogs(): array {
    return $this->result;
  }

}
