<?php

namespace Drupal\gamify\EventSubscriber;

use Drupal\eca\EcaEvents;
use Drupal\eca\Event\BeforeInitialExecutionEvent;
use Drupal\gamify\Event\RecentLogs;
use Drupal\gamify\Plugin\ECA\Event\GamifyEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * ECA event subscriber.
 */
class EcaGamify implements EventSubscriberInterface {

  /**
   * Subscriber method before initial execution.
   *
   * @param \Drupal\eca\Event\BeforeInitialExecutionEvent $before_event
   *   The according event.
   *
   * @throws \Drupal\Component\Plugin\Exception\InvalidPluginDefinitionException
   * @throws \Drupal\Component\Plugin\Exception\PluginNotFoundException
   */
  public function onBeforeInitialExecution(BeforeInitialExecutionEvent $before_event): void {
    $event = $before_event->getEvent();
    if ($event instanceof RecentLogs) {
      $this->tokenService->addTokenData('logged_user', $event->getUser());
      $this->tokenService->addTokenData('recent_logs', $event->getRecentLogs());
      $this->tokenService->addTokenData('last_run', $event->getLastRun());
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = [];
    # foreach (GamifyEvent::definitions() as $definition) {
    #   $events[$definition['event_name']][] = ['onEvent'];
    # }
    $events[EcaEvents::BEFORE_INITIAL_EXECUTION][] = ['onBeforeInitialExecution'];
    return $events;
  }

}
