<?php

namespace Drupal\gamify\Plugin\Action;

use Drupal\eca\Plugin\Action\ConfigurableActionBase;
use Drupal\gamify\WatchdogService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Describes the gamify_logs_init_eval_service action.
 *
 * @Action(
 *   id = "gamify_logs_init_eval_service",
 *   label = @Translation("Gamify: Init logs evaluation service."),
 *   description = @Translation("Initialize the log analysis for each user.")
 * )
 */
class LogsInitEvalService extends ConfigurableActionBase {

  /**
   * Drupal\gamify\UserPointsLogService definition.
   *
   * @var \Drupal\gamify\WatchdogService
   */
  protected WatchdogService $watchdogService;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    /** @var \Drupal\gamify\Plugin\Action\InitializeWatchdogService $instance */
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->setWatchdogService($container->get('gamify.watchdog_service'));
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function execute() {
    $this->watchdogService->initRun('eca_cron');
  }

  /**
   * Set Drupal\gamify\WatchdogService definition.
   *
   * @param \Drupal\gamify\WatchdogService $watchdog_service
   *   The user points log service.
   */
  public function setWatchdogService(WatchdogService $watchdog_service): void {
    $this->watchdogService = $watchdog_service;
  }

}
