<?php

namespace Drupal\gamify\Plugin\ECA\Event;

use Drupal\eca\Event\Tag;
use Drupal\eca\Plugin\ECA\Event\EventBase;
use Drupal\gamify\Event\GamifyEvents;
use Drupal\gamify\Event\RecentLogs;

/**
 * Plugin implementation of the ECA Events for gamify module.
 *
 * @EcaEvent(
 *   id = "gamify",
 *   deriver = "Drupal\gamify\Plugin\ECA\Event\GamifyEventDeriver"
 * )
 */
class GamifyEvent extends EventBase {

  /**
   * {@inheritdoc}
   */
  public static function definitions(): array {
    return [
      'recent_logs' => [
        'label' => 'Eval recent logs',
        'description' => 'Provides 3 tokens: logged_user, recent_logs, last_run',
        'event_name' => GamifyEvents::RECENT_LOGS,
        'event_class' => RecentLogs::class,
        'tags' => Tag::WRITE | Tag::EPHEMERAL | Tag::AFTER,
      ],
    ];
  }

}
