<?php

namespace Drupal\gamify\TypedData\Options;

use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\gamify\TypedData\Options\OptionsProviderBase;

/**
 * Options provider for the types of field access to check for.
 */
class AbstractUserOptions extends OptionsProviderBase {


  const CURRENT_USER = 'current_user';
  const ENTITY_CREATOR = 'entity_creator';
  const PARENT_ENTITY_CREATOR = 'parent_entity_creator';
  const INVOLVED_USERS = 'involved_users';

  /**
   * {@inheritdoc}
   */
  public function getPossibleOptions(AccountInterface $account = NULL): array {
    return self::getOptions();
  }

  public static function getOptions(): array {
    return [
      self::CURRENT_USER => new TranslatableMarkup('Current user'),
      self::ENTITY_CREATOR => new TranslatableMarkup('Entity creator'),
      self::PARENT_ENTITY_CREATOR => new TranslatableMarkup('Parent entity creator'),
      self::INVOLVED_USERS => new TranslatableMarkup('Involved users'),
    ];
  }
}
