<?php

namespace Drupal\gamify\TypedData\Options;

use Drupal\Core\DependencyInjection\ContainerInjectionInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\gamify\TypedData\Options\OptionsProviderBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Options provider for the types of field access to check for.
 */
class AlertTemplateOptions extends OptionsProviderBase {

  /**
   * {@inheritdoc}
   */
  public function getPossibleOptions(AccountInterface $account = NULL): array {
    return self::getOptions();
  }

  public static function getOptions(): array {
    /** @var \Drupal\gamify\Entity\AlertTemplateInterface[] $templates */
    $templates = \Drupal::entityTypeManager()->getStorage('alert_template')->loadMultiple();
    $options = [];
    foreach ($templates as $key => $template) {
      $options[$key] = $key;
    }
    return $options;

  }

}
