<?php

namespace Drupal\gamify\TypedData\Options;

use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\gamify\TypedData\Options\OptionsProviderBase;

/**
 * Options provider for the types of field access to check for.
 */
class EntityOperationOptions extends OptionsProviderBase {

  const CREATE = 'create';
  const VIEW = 'view';
  const UPDATE = 'update';
  const DELETE = 'delete';
  const REVERT = 'revert';
  const VOTE_REWARD = 'vote_reward';
  const RATIFY_REWARD = 'ratify_reward';

  /**
   * {@inheritdoc}
   */
  public function getPossibleOptions(AccountInterface $account = NULL): array {
    return self::getOptions();
  }

  public static function getOptions(): array {
    return [
      self::CREATE => new TranslatableMarkup('Create'),
      self::VIEW => new TranslatableMarkup('View'),
      self::UPDATE => new TranslatableMarkup('Update'),
      self::DELETE => new TranslatableMarkup('Delete'),
      self::REVERT => new TranslatableMarkup('Revert'),
      self::VOTE_REWARD => new TranslatableMarkup('Vote reward'),
      self::RATIFY_REWARD => new TranslatableMarkup('Ratification reward'),
    ];
  }

}
