<?php

namespace Drupal\gamify\TypedData\Options;

use Drupal\Core\Session\AccountInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\gamify\TypedData\Options\OptionsProviderBase;

/**
 * Options provider for the types of field access to check for.
 */
class UserPointsTypeOptions extends OptionsProviderBase {


  const ADVANCEMENT = 'advancement';

  /**
   * {@inheritdoc}
   */
  public function getPossibleOptions(AccountInterface $account = NULL): array {
    return self::getOptions();
  }

  public static function getOptions(): array {
    return [
      self::ADVANCEMENT => new TranslatableMarkup('Advancement'),
    ];
  }

}
