/**
 * @file
 * Popup behaviors.
 */

(function (window, $) {
  Drupal.gayaPopup = Drupal.gayaPopup || {};
  if ($(drupalSettings.id).length === 0) {
    $.ajax({
      url: `${
        drupalSettings.path.baseUrl + drupalSettings.path.pathPrefix
      }popup/ajax/get-message?zone=${drupalSettings.zone}`,
      method: 'GET',
      dataType: 'json',
      async: true,
      jsonp: false,
      success(result) {
        if (result) {
          Drupal.gayaPopup.process(result);
        }
      },
    });
  }

  // Add popup only if conditions are met.
  Drupal.gayaPopup.process = function (result) {
    Drupal.gayaPopup.addCss();
    const wrapper = document.createElement('div');
    wrapper.innerHTML = result;
    const popover = wrapper.querySelector(drupalSettings.id);
    if (popover) {
      const popupId = popover.dataset.popupid;

      const status = Drupal.gayaPopup.checkPopupStatus(popupId, popover);

      if (status) {
        return;
      }

      const close = Drupal.gayaPopup.checkPopupClose(popupId, popover);
      if (close) {
        return;
      }

      Drupal.gayaPopup.add(result, popupId, popover);

      Drupal.gayaPopup.close(popupId);
    }
  };

  // Add custom CSS change.
  Drupal.gayaPopup.addCss = function () {
    if (drupalSettings.css) {
      document.documentElement.style.setProperty(
        '--popover-offset',
        drupalSettings.offset,
      );
      document.documentElement.style.setProperty(
        '--popover-background-color',
        drupalSettings.background_color,
      );
      document.documentElement.style.setProperty(
        '--popover-text-color',
        drupalSettings.text_color,
      );
      document.documentElement.style.setProperty(
        '--popover-font-size',
        drupalSettings.font_size,
      );
    }
  };

  // If already see don't display if option checked.
  Drupal.gayaPopup.checkPopupStatus = function (popupId, popover) {
    const popupStatus = sessionStorage.getItem(`popupStatus${popupId}`)
      ? sessionStorage.getItem(`popupStatus${popupId}`)
      : false;
    const frequency = popover.dataset.frequency;
    return popupStatus && frequency === 'once';
  };

  // If already closed don't display if option checked.
  Drupal.gayaPopup.checkPopupClose = function (popupId, popover) {
    const popupClosed = sessionStorage.getItem(`popupClosed${popupId}`)
      ? sessionStorage.getItem(`popupClosed${popupId}`)
      : false;
    const ifClosed = popover.dataset.closed;
    return ifClosed === '1' && popupClosed;
  };

  // Add popup in page.
  Drupal.gayaPopup.add = function (result, popupId, popover) {
    $(drupalSettings.target).before(result);
    sessionStorage.setItem(`popupStatus${popupId}`, true);
    popover.focus();
  };

  // Add action on popup close.
  Drupal.gayaPopup.close = function (popupId) {
    $(document).on(
      'click',
      `${drupalSettings.id} ${drupalSettings.close}`,
      function () {
        sessionStorage.setItem(`popupClosed${popupId}`, true);
        document.querySelector(drupalSettings.id).style.transform =
          'translateX(100%)';
      },
    );
  };
})(window, jQuery);
