/**
 * @file
 * Popup behaviors.
 */

(function (window, Drupal, drupalSettings, $) {
  Drupal.gayaPopup = Drupal.gayaPopup || {};
  document.addEventListener('DOMContentLoaded', () => {
    if (drupalSettings.gayaPopup.popups) {
      Drupal.gayaPopup.processAll(drupalSettings.gayaPopup.popups);
    }
  });

  // Check all popup.
  Drupal.gayaPopup.processAll = function (popups) {
    popups.every((popup) => {
      const validate = Drupal.gayaPopup.process(popup);

      // Check another popup if this one is not valid.
      return !validate;
    });
  };

  // Add popup only if conditions are met.
  Drupal.gayaPopup.process = function (popup) {
    Drupal.gayaPopup.addCss();

    const date = Drupal.gayaPopup.checkDate(popup);
    if (!date) {
      return false;
    }
    const status = Drupal.gayaPopup.checkPopupStatus(popup.id, popup.status);
    if (status) {
      return true;
    }

    const close = Drupal.gayaPopup.checkPopupClose(popup.id, popup.closed);
    if (close) {
      return true;
    }

    const idSelector = `[data-popupid='${popup.id}']`;

    Drupal.gayaPopup.add(popup.html, popup.id, idSelector);

    Drupal.gayaPopup.close(popup.id, idSelector);

    return true;
  };

  // Add custom CSS change.
  Drupal.gayaPopup.addCss = function () {
    if (drupalSettings.gayaPopup.css) {
      document.documentElement.style.setProperty(
        '--popover-offset',
        drupalSettings.gayaPopup.offset,
      );
      document.documentElement.style.setProperty(
        '--popover-background-color',
        drupalSettings.gayaPopup.background_color,
      );
      document.documentElement.style.setProperty(
        '--popover-text-color',
        drupalSettings.gayaPopup.text_color,
      );
      document.documentElement.style.setProperty(
        '--popover-font-size',
        drupalSettings.gayaPopup.font_size,
      );
    }
  };

  // Check if the popup is within the time period.
  Drupal.gayaPopup.checkDate = function (popup) {
    let now = new Date().toLocaleString('en-US', {
      timeZone: drupalSettings.gayaPopup.timezone,
    });
    now = new Date(now);
    const start = popup.dateStart ? new Date(popup.dateStart) : null;
    const end = popup.dateEnd ? new Date(popup.dateEnd) : null;
    if ((start && start > now) || (end && end < now)) {
      return false;
    }
    if (popup.hourStart && popup.hourEnd) {
      const hour = `${`0${now.getHours()}`.slice(-2)}:${`0${now.getMinutes()}`.slice(
        -2,
      )}`;
      if (hour < popup.hourStart || popup.hourEnd < hour) {
        return false;
      }
    }
    return true;
  };

  // If already see don't display if option checked.
  Drupal.gayaPopup.checkPopupStatus = function (popupId, frequency) {
    const popupStatus = sessionStorage.getItem(`popupStatus${popupId}`)
      ? sessionStorage.getItem(`popupStatus${popupId}`)
      : false;
    return popupStatus && frequency === 'once';
  };

  // If already closed don't display if option checked.
  Drupal.gayaPopup.checkPopupClose = function (popupId, closed) {
    const popupClosed = sessionStorage.getItem(`popupClosed${popupId}`)
      ? sessionStorage.getItem(`popupClosed${popupId}`)
      : false;
    return closed === '1' && popupClosed;
  };

  // Add popup in page.
  Drupal.gayaPopup.add = function (result, popupId, selector) {
    const html = $(result);
    html.addClass(drupalSettings.gayaPopup.class);
    html.attr('data-popupid', popupId);
    html.attr('tabindex', '-1');
    $(drupalSettings.gayaPopup.target).before(html);
    sessionStorage.setItem(`popupStatus${popupId}`, true);
    document.querySelector(selector).focus();
  };

  // Add action on popup close.
  Drupal.gayaPopup.close = function (popupId, selector) {
    $(document).on(
      'click',
      `${selector} ${drupalSettings.gayaPopup.close}`,
      function () {
        sessionStorage.setItem(`popupClosed${popupId}`, true);
        document.querySelector(selector).style.transform = 'translateX(100%)';
      },
    );
  };
})(window, Drupal, drupalSettings, jQuery);
