<?php

declare(strict_types=1);

namespace Drupal\gaya_popup\Controller;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\Routing\AdminContext;
use Drupal\Core\Url;
use Drupal\gaya_popup\Entity\GayaPopup;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for Gaya Popup.
 */
class GayaPopupBaseController extends ControllerBase {

  /**
   * Constructs the SchemaListenerController object.
   */
  public function __construct(protected Request $request, protected LoggerInterface $logger, protected AdminContext $adminContext, protected CacheBackendInterface $cache, protected TimeInterface $time, protected readonly RendererInterface $renderer) {
  }

  /**
   * {@inheritdoc}
   */
  #[\Override]
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('request_stack')->getCurrentRequest(),
      $container->get('logger.factory')->get('popup_entity'),
      $container->get('router.admin_context'),
      $container->get('cache.default'),
      $container->get('datetime.time'),
      $container->get('renderer'),
    );
  }

  /**
   * Enable a gaya Popup.
   */
  public function enableMessage(GayaPopup $popupmessage): RedirectResponse|array {
    if (!$this->currentUser()
      ->hasPermission('edit popup messages entity entities')) {
      return new RedirectResponse(Url::fromRoute('<front>')->toString());
    }

    try {
      $popupmessage->set('status', '1');
      $popupmessage->save();
    }
    catch (\Exception $e) {

      $this->logger->error($e->getMessage());
    }

    $response = new RedirectResponse(Url::fromRoute('gaya_popup.popup_entity_settings')
      ->toString());
    $response->send();
    return [];
  }

  /**
   * Disable a gaya popup.
   */
  public function disableMessage(GayaPopup $popupmessage): RedirectResponse|array {
    if (!$this->currentUser()
      ->hasPermission('edit popup messages entity entities')) {
      return new RedirectResponse(Url::fromRoute('<front>')->toString());
    }

    try {
      $popupmessage->set('status', '0');
      $popupmessage->save();
    }
    catch (\Exception $e) {
      $this->logger->error($e->getMessage());
    }

    $response = new RedirectResponse(Url::fromRoute('gaya_popup.popup_entity_settings')
      ->toString());
    $response->send();
    return [];
  }

}
