<?php

namespace Drupal\gcds_test\Form;

use Drupal\Component\Utility\Html;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for testing.
 */
class GcdsTestForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'gcds_test_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $form['fieldset_1'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Test fieldset 1 title'),
      '#description' => $this->t('Test fieldset 1 description'),
      '#description_display' => 'before',
      '#attributes' => [
        'class' => ['class_1', 'class_2'],
        'id' => Html::getUniqueId('fieldset-id'),
      ],
      'content' => [
        '#markup' => $this->t('Test fieldset 1 content'),
      ],
    ];
    $form['fieldset_2'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Test fieldset 2 title'),
      '#legend-size' => 'h2',
      'content' => [
        '#markup' => $this->t('Test fieldset 2 content'),
      ],
    ];

    $form['radios_1'] = [
      '#type' => 'radios',
      '#title' => $this->t('Test radios 1 title'),
      '#description' => $this->t('Test radios 1 description'),
      '#options' => [
        1 => 'One',
        'two' => 'Two',
      ],
      '#required' => TRUE,
    ];
    $form['radios_2'] = [
      '#type' => 'radios',
      '#title' => $this->t('Test radios 2 title'),
      '#options' => [
        'three' => $this->t('Three'),
        'four' => $this->t('Four'),
      ],
      '#value' => 'four',
    ];

    $form['checkboxes_1'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Test checkboxes 1 title'),
      '#description' => $this->t('Test checkboxes 1 description'),
      '#required' => TRUE,
      '#return_value' => 1,
    ];
    $form['checkboxes_2'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Test checkboxes 2 title'),
      '#return_value' => 'two',
      '#value' => 'two',
    ];

    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Submit'),
    ];
    $form['actions']['reset'] = [
      '#type' => 'submit',
      '#name' => 'reset',
      '#value' => $this->t('Reset'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
  }

}
