## Overview

The GCDS theme is based on the new [Government of Canada Design System](https://design-system.alpha.canada.ca) (GCDS). It ensures consistent navigation and design across all sites using it. This Drupal theme uses Single Directory Components (SDCs) and loads CSS and JavaScript from the GCDS CDN. This means any updates to the design system will automatically be applied to your site as soon as they're available.

## Theme settings and customization

You can customize the theme settings to suit your project’s needs.

### Top navigation menu

Choose between the Canada․ca topic menu or a Drupal menu block. To display a
Drupal menu, add a menu block to region "GCDS Header `menu` slot". For the topic
menu, leave this region empty and check theme setting "Show GCDS theme and topic
menu".

![Screenshot showing the Canada.ca topic menu](docs-assets/screenshot-canada-topics-menu.png)
_Screenshot: Canada․ca topic menu_

![Screenshot showing the Drupal main navigation](docs-assets/screenshot-canada-drupal-menu.png)
_Screenshot: Drupal main navigation_

### Breadcrumbs

You can choose to show or hide breadcrumbs.

### Forms

You can choose whether or not to use **GCDS forms**.

When GCDS forms are enabled, elements render as custom components like
<gcds-input>. In most cases, this works well.

However, if your form relies on JavaScript for custom logic or interactions, you
should opt out of GCDS forms. This will render standard HTML elements styled
with GCDS CSS instead of web components.

If you need to completely revert to browser default styles (ignoring GCDS CSS),
add the `ge-form-reset` class to your form element:

```html
<form class="ge-form-reset">
 …
</form>
```

### Search settings

Choose one of the following search options:

- None
- Canada․ca search
- Local site search

### Footer display

Choose one of the following footer options:

- None
- Full Government of Canada footer
- Compact Government of Canada footer

### Footer menu

The footer menu is a contextual navigation menu unique to your project.

#### Using a translated menu

This option is best if all your menu links point to pages within Drupal.

1. Create a menu as usual.
2. Make it translatable.
3. Translate the menu as needed.
4. On the theme settings page, select the menu you created in step 1.

If you have menu links translated with `translatable_menu_link_uri` module,
these translated links will be used.

#### Using separate menus for each language

Use this option if your menu includes links to external sites or if your links
don’t use Drupal’s translation system. In Drupal, you can translate menu labels,
but not the URLs they point to.

1. Create a menu as usual. Note the machine name, for example, `my_menu`.
2. Create a second menu with the same machine name as the one you just created,
   but append `-lang-` followed by the language code. For example,
   `my_menu-lang-fr` for French or `my_menu-lang-pt` for Portuguese.
3. On the theme settings page, select the menu you created in step 1.

This will create separate menus for each language.

>**How the code works**
>
>1. The code first checks for a version of the selected menu with a language
>   suffix, like `-lang-fr`.
>2. If a suffix is found, the corresponding menu will be displayed.
>3. If no suffix is found, Drupal will check for a translation of the menu and
>   display it if available.
>4. If neither a suffix nor a translation is found, the default language menu
>   will be displayed, regardless of the interface language.
>
> [List of ISO 639 language codes](https://en.wikipedia.org/wiki/List_of_ISO_639_language_codes)

![Screenshot of GCDS footer with contextual footer](docs-assets/screenshot-contextual-footer-with-full-footer.png)
_Screenshot: contextual footer with the full GC footer selected_

### GCDS Version

By default, the GCDS version is set to `@latest`. You can lock to a specific
version by entering the version number.

[List of GCDS releases](https://github.com/cds-snc/gcds-components/releases).


## Using with Field Group module (`field_group`)

When grouping fields with `field_group` module, you can use `gcds-heading` for
the group label. Set the label element to `gcds-heading` and configure the
heading level by setting a label element HTML class. Use a class like
`gcds-heading-hN` where `N` is any number 2-6, such as `gcds-heading-h3`. If you
leave out the class, it will use `h2`.
