# GCLID

Capture, store, and auto-populate form fields with the visitor's Google Click ID (GCLID) from Google Ads.

## Post-installation

Head over to *Administration -> Configuration -> Web services -> Configure GCLID settings* to configure which fields should be auto-populated, GCLID expiration, and which roles this GCLID-capturing functionality should be enabled for.

## Additional requirements

A typical setup might look like this:
 - Google Ads is configured to send the GCLID as a URL query parameter when someone clicks an ad.
 - A hidden GCLID field exists in your forms.  This module transfers the visitor's GCLID into that hidden field.
 - Form submissions (along with the GCLID) are transmitted into a CRM or other system.
 - The CRM or other system is connected to Google Ads to communicate, via GCLID, when a deeper-level conversion action happens.

## Recommended modules/libraries

 - [Google Tag](https://www.drupal.org/project/google_tag)
 - [Webform](https://www.drupal.org/project/webform)

## Supporting this module

Report bugs, feature requests, or other issues, and propose resolutions via merge requests or patches.

## Supporting documentation

 - [How to set up a Salesforce integration](https://support.google.com/google-ads/answer/13548778)
