<?php

namespace Drupal\gcs_backup\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form.
 */
class GcsBackupSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['gcs_backup.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'gcs_backup_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('gcs_backup.settings');

    $form['bucket_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('GCS Bucket Name'),
      '#default_value' => $config->get('bucket_name'),
      '#required' => TRUE,
    ];

    $form['prefix_backup'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Backup Prefix'),
      '#default_value' => $config->get('prefix_backup'),
      '#description' => $this->t('Can only contain lowercase letters, numbers, and underscores.'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state) {
    parent::validateForm($form, $form_state);

    $value = $form_state->getValue('prefix_backup');
    if (!preg_match('/^[a-z0-9_]+$/', $value)) {
      $form_state->setErrorByName('prefix_backup', $this->t('The field can only contain lowercase letters, numbers, and underscores.'));
    }
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('gcs_backup.settings')
      ->set('bucket_name', $form_state->getValue('bucket_name'))
      ->set('prefix_backup', $form_state->getValue('prefix_backup'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
