<?php

namespace Drupal\generate_style_theme\Services;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Extension\ExtensionPathResolver;
use Stephane888\Debug\debugLog;
use Stephane888\Debug\Repositories\ConfigDrupal;
use Drupal\generate_style_theme\Entity\FilesStyle;

class ManageFileCustomStyle extends ControllerBase {
  
  /**
   *
   * @var string
   */
  protected $path;
  
  /**
   * Permet de definir un theme autre que celui encours pour la sauvegarde.
   *
   * @var string
   */
  public $theme_name;
  
  /**
   *
   * @var ExtensionPathResolver
   */
  protected $ExtensionPathResolver;
  /**
   *
   * @var array
   */
  protected $generate_style_themeSettings = [];
  
  function __construct(ExtensionPathResolver $ExtensionPathResolver) {
    $this->ExtensionPathResolver = $ExtensionPathResolver;
  }
  
  /**
   * --
   *
   * @return string
   */
  protected function getPath() {
    if (!$this->path) {
      $this->getSelectedTheme();
      $this->path = DRUPAL_ROOT . '/' . $this->ExtensionPathResolver->getPath('theme', $this->theme_name) . '/wbu-atomique-theme/src';
    }
    return $this->path;
  }
  
  /**
   * --
   *
   * @return string
   */
  protected function getSelectedTheme() {
    if (!$this->theme_name) {
      $conf = ConfigDrupal::config('system.theme');
      $this->theme_name = $conf['default'];
    }
    return $this->theme_name;
  }
  
  public function getConfigGenerateStyleTheme() {
    if (!$this->generate_style_themeSettings) {
      $this->generate_style_themeSettings = ConfigDrupal::config('generate_style_theme.settings');
    }
    return $this->generate_style_themeSettings;
  }
  
  /**
   * Ecrase le contenu scss existant.
   * L'idee est de permettre à plusieurs modules d'ajouter du contenu dans le
   * fichier. Pour ce faire on va passer par une entité.
   *
   * @param string $string
   * @deprecated car il faudra enregistrer le scss et le js dans la meme entité.
   *             Use saveStyle()
   *             delete in 5x
   */
  public function saveScss($string, $key, $module) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      $entity->setScss($string);
      $entity->save();
    }
    else {
      $values = [
        'label' => $key,
        'module' => $module,
        'scss' => $string
      ];
      $entity = FilesStyle::create($values);
      $entity->save();
    }
    $this->generateCustomFile();
  }
  
  /**
   * Ecrase le contenu js existant
   *
   * @param string $string
   * @deprecated car il faudra enregistrer le scss et le js dans la meme entité.
   *             Use saveStyle()
   *             delete in 5x
   */
  public function saveJs($string, $key, $module) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      $entity->setScss($string);
      $entity->save();
    }
    else {
      $values = [
        'label' => $key,
        'module' => $module,
        'scss' => $string
      ];
      $entity = FilesStyle::create($values);
      $entity->save();
    }
    $this->generateCustomFile();
  }
  
  /**
   * Permet d'enregistrer les styles pour un module.
   * Utiliser principalement pour les styles de surcharge.
   *
   * @param string $key
   * @param string $module
   * @param string $scss
   * @param string $js
   * @param array $customValue,
   *        permet de passer des valeurs specique unqiuement lors de la
   *        creation.
   */
  public function saveStyle($key, $module, $scss, $js, $route_name = "", $customValue = []) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      $entity->setScss($scss);
      $entity->setJs($js);
      $entity->setRouteName($route_name);
      $entity->save();
    }
    else {
      $values = [
        'label' => $key,
        'module' => $module,
        'scss' => $scss,
        'js' => $js,
        'route_name' => $route_name
      ] + $customValue;
      $entity = FilesStyle::create($values);
      $entity->save();
    }
    $this->generateCustomFile();
    return $entity;
  }
  
  /**
   * Permet de supprimer un style.
   *
   * @param string $key
   * @param string $module
   */
  public function deleteStyle($key, $module) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      $entity->delete();
    }
  }
  
  /**
   * Genere les fichiers de base.
   *
   * @param boolean $save_multifile
   */
  public function generateCustomFile($save_multifile = false) {
    /**
     * L'enssemble des styles present dans l'entite ne vont pas dans custom.
     *
     * @var array $entities
     */
    $entities = FilesStyle::loadMultiple();
    $variable_file = './' . $this->getSelectedTheme() . '_variables.scss';
    $base_scss = '    @use "' . $variable_file . '" as *;    ';
    if (!empty($this->getConfigGenerateStyleTheme()['tab1']['vendor_import']['load_custom_in_vendor'])) {
      $base_scss .= '
      // On charge ces imports afin de pouvoir utiliser @extend.
      @use "@stephane888/wbu-atomique/scss/bootstrap-all.scss" as *;
      @use "@stephane888/wbu-atomique/scss/atome/typography/_default.scss" as *;
      @use "@stephane888/wbu-atomique/scss/molecule/default-class.scss" as *;
      ';
    }
    $scss = $base_scss;
    $js = '';
    /**
     *
     * @var \Drupal\generate_style_theme\Entity\FilesStyle $entity
     */
    foreach ($entities as $entity) {
      $file_name = "custom";
      if ($save_multifile) {
        /**
         * On garde uniquement les styles ajoutés dans le module
         * generate_style_theme.
         * Car ces styles sont en principe utiliser sur toutes les pages.
         *
         * @var \Drupal\generate_style_theme\Entity\FilesStyle $entity
         */
        if ($entity->getModule() == 'generate_style_theme') {
          $file_name = $entity->label();
        }
      }
      // Add comment
      $prefix = "\n";
      $prefix .= "// module : " . $entity->getModule() . ' || ' . $entity->label();
      $prefix .= " \n";
      $currentScss = $entity->getScss();
      
      if ($file_name != "custom") {
        $custom_scss = $base_scss . $currentScss;
        
        debugLog::logger($entity->getJs(), "$file_name.js", false, 'file', $this->getPath() . '/js', true);
        debugLog::logger($custom_scss, "$file_name.scss", false, 'file', $this->getPath() . '/scss', true);
      }
      else {
        if (!empty($currentScss)) {
          $scss .= $prefix . $currentScss;
        }
        $currentJs = $entity->getJs();
        if (!empty($currentJs)) {
          $js .= $prefix . $currentJs;
        }
      }
    }
    debugLog::logger($js, "custom.js", false, 'file', $this->getPath() . '/js', true);
    debugLog::logger($scss, "custom.scss", false, 'file', $this->getPath() . '/scss', true);
  }
  
  /**
   * Permet de recuperer le style d'un module.
   *
   * @return string|boolean
   */
  public function getScss($key, $module) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      return $entity->getScss();
    }
  }
  
  /**
   * Permet de recuperer le style d'un module.
   *
   * @return string|boolean
   */
  public function getJs($key, $module) {
    $entity = FilesStyle::loadByName($key, $module);
    if ($entity) {
      return $entity->getJs();
    }
  }
  
}
