<?php

namespace Drupal\Tests\generic_colors\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Kernel tests for the GetImageColors tool plugin.
 *
 * These tests verify simple validation and failure paths without needing to
 * create files or media entities.
 */
class GetImageColorsTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'generic_colors',
    'tool',
    'ai',
    'ai_agents',
  ];

  /**
   * Ensure the plugin manager is available and the plugin can be instantiated.
   */
  public function testMissingIdsReturnsFailure(): void {
    $plugin_manager = $this->container->get('plugin.manager.tool');
    $plugin = $plugin_manager->createInstance('ai_agent:get_image_colors', []);

    // No inputs provided should produce a failure telling the user to provide
    // one of the id parameters.
    $plugin->execute();
    $this->assertFalse($plugin->getResultStatus());
    $this->assertStringContainsString(
      'Please provide one of the id parameters',
      (string) $plugin->getResultMessage()
    );
  }

  /**
   * Invalid file id (non-numeric) should return an "Invalid file id." failure.
   */
  public function testInvalidFileIdReturnsFailure(): void {
    $plugin_manager = $this->container->get('plugin.manager.tool');
    $plugin = $plugin_manager->createInstance('ai_agent:get_image_colors', []);

    // Provide a non-numeric file id.
    $plugin->setInputValue('file_id', 'not-a-number');
    $plugin->execute();

    $this->assertFalse($plugin->getResultStatus());
    $this->assertStringContainsString(
      'Invalid file id',
      (string) $plugin->getResultMessage()
    );
  }

}
