<?php

namespace Drupal\gevent\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;


/**
 * Provides routes for group_event group content.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    if ($route = $collection->get('entity.group_relationship.create_page')) {
      $copy = clone $route;
      $copy->setPath('group/{group}/event/create');
      $copy->setDefault('base_plugin_id', 'group_event');
      $collection->add('entity.group_relationship.group_event_create_page', $copy);
    }

    if ($route = $collection->get('entity.group_relationship.add_page')) {
      $copy = clone $route;
      $copy->setPath('group/{group}/event/add');
      $copy->setDefault('base_plugin_id', 'group_event');
      $collection->add('entity.group_relationship.group_event_add_page', $copy);
    }
  }

}
