<?php

namespace Drupal\gevent\Plugin\Group\Relation;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\event\Entity\EventType;
use Drupal\group\Plugin\Group\Relation\GroupRelationTypeInterface;

class GroupEventDeriver extends DeriverBase {

  /**
   * {@inheritdoc}.
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    assert($base_plugin_definition instanceof GroupRelationTypeInterface);
    $this->derivatives = [];

    foreach (EventType::loadMultiple() as $name => $event_type) {
      $label = $event_type->label();

      $this->derivatives[$name] = clone $base_plugin_definition;
      $this->derivatives[$name]->set('entity_bundle', $name);
      $this->derivatives[$name]->set('label', t('Group event (@type)', ['@type' => $label]));
      $this->derivatives[$name]->set('description', t('Adds %type events to groups both publicly and privately.', ['%type' => $label]));
    }

    return $this->derivatives;
  }

}
