# Gift Aid Commerce

Supports Gift Aid declarations associated with Commerce orders.

This module provides a checkout pane that allows you to request customers to
make a gift aid declaration while completing an order.

## Installation
As normal. Requires the parent Gift Aid module to be installed.

## Usage

1. Ensure you have already created a charity for Gift Aid.

2. Enable the 'Collect Gift Aid' setting in your Commerce store and
set the charity there.

3. Add the 'Gift Aid Declaration' pane to the checkout flow.

## Where to place the pane in your checkout flow

The default checkout flows that Commerce provides contain a 'review' step prior
to payment, and you can place the Gift Aid pane here.

If you wish to solicit a Gift Aid declaration after payment
and after the order is placed on the 'complete' step,
then create a custom checkout flow plugin with a step after 'complete' and place
the Gift Aid pane on the 'complete' step.

## Restricting the checkout pane

If you wish to only show the gift aid checkout pane on some orders, you can

1. Use a separate checkout flow
2. Enable the 'Gift Aid Commerce Product' module and specify which products are
   eligible for Gift Aid.
3. Use custom code to subscribe to the gift_aid_commerce.order_info event
