<?php

namespace Drupal\gift_aid_commerce\Event;

/**
 * The names of events used by the Gift Aid Commerce module.
 */
final class GiftAidCommerceEvents {

  /**
   * The name of the event fired when finding gift aid information for an order.
   *
   * This event allows you to customize whether and how an order should solicit a gift aid declaration.
   *
   * @Event
   *
   * @see \Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent
   */
  const ORDER_INFO = 'gift_aid_commerce.order_info';

}
