<?php

namespace Drupal\gift_aid_commerce\EventSubscriber;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\gift_aid\Entity\CharityInterface;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceEvents;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber to set the charity from the store.
 */
class GiftAidOrderStoreCharitySubscriber implements EventSubscriberInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Constructs a new OrderSubscriber object.
   *
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager) {
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events = [
      GiftAidCommerceEvents::ORDER_INFO => ['setCharityFromStore'],
    ];
    return $events;
  }

  /**
   * Specify the gift aid charity for the order from the store or default.
   *
   * @param \Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent $event
   *   The order info event.
   */
  public function setCharityFromStore(GiftAidCommerceOrderInfoEvent $event) {
    $store = $event->getOrder()->getStore();
    $charity = $store->get('gift_aid_charity')->entity;
    if (!$charity) {
      $charity = $this->entityTypeManager->getStorage('gift_aid_charity')->loadDefault();
    }
    if ($charity instanceof CharityInterface) {
      $event->setCharity($charity);
    }
  }

}
