<?php

namespace Drupal\gift_aid_commerce\EventSubscriber;

use Drupal\gift_aid_commerce\OrderDeclarationManagerInterface;
use Drupal\state_machine\Event\WorkflowTransitionEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber to create declarations when orders are placed.
 */
class OrderPlaceSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new OrderSubscriber object.
   *
   * @param Drupal\gift_aid_commerce\OrderDeclarationManagerInterface $orderService
   *   The order service.
   */
  public function __construct(protected readonly OrderDeclarationManagerInterface $orderService) {
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events['commerce_order.place.post_transition'] = 'onPlace';
    return $events;
  }

  /**
   * Creates declaration when the order is placed if appropriate.
   *
   * @param \Drupal\state_machine\Event\WorkflowTransitionEvent $event
   *   The transition event.
   */
  public function onPlace(WorkflowTransitionEvent $event) {
    /** @var \Drupal\commerce_order\Entity\OrderInterface $order */
    $order = $event->getEntity();

    // Only create a declaration if the order is marked as having had a declaration.
    if ($order->getData('gift_aid_commerce_declared')) {
      $this->orderService->declare($order);
    }
  }

}
