<?php

namespace Drupal\gift_aid_commerce;

use Drupal\commerce_order\Entity\OrderInterface;

/**
 * The order declaration manager interface.
 */
interface OrderDeclarationManagerInterface {

  /**
   * Gets the donor entity from an order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order.
   *
   * @return \Drupal\gift_aid\Entity\DonorInterface
   *   The donor.
   */
  public function getDonor(OrderInterface $order);

  /**
   * Makes a declaration from an order.
   *
   * @param \Drupal\commerce_order\Entity\OrderInterface $order
   *   The order.
   */
  public function declare(OrderInterface $order);

}
