<?php

namespace Drupal\gift_aid_commerce_test\EventSubscriber;

use Drupal\gift_aid_commerce\Event\GiftAidCommerceEvents;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Sets order items as eligible for testing.
 */
class GiftAidOrderStateEligibleSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events = [
      GiftAidCommerceEvents::ORDER_INFO => ['setEligibleFromState'],
    ];
    return $events;
  }

  /**
   * Specify the order as gift aid eligible based on state.
   *
   * @param \Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent $event
   *   The order info event.
   */
  public function setEligibleFromState(GiftAidCommerceOrderInfoEvent $event) {
    $eligible = \Drupal::state()->get('gift_aid_commerce_test_eligible');
    if ($eligible) {
      $item = $event->getOrder()->getItems()[0];
      $event->addEligibleItem($item);
    }
  }

}
