<?php

namespace Drupal\Tests\gift_aid_commerce\Functional;

use Drupal\Tests\commerce\Functional\CommerceBrowserTestBase;

/**
 * Test whether we have the gift aid pane in the default checkout flow.
 *
 * @group gift_aid_commerce
 */
class PaneAdminTest extends CommerceBrowserTestBase {

  /**
   * Module to enable.
   *
   * @var array
   */
  protected static $modules = [
    'gift_aid_commerce',
    'commerce_checkout',
  ];

  /**
   * {@inheritdoc}
   */
  protected function getAdministratorPermissions() {
    return array_merge([
      'administer commerce_checkout_flow',
    ], parent::getAdministratorPermissions());
  }

  /**
   * Verify that the gift aid setting is in a checkout flow pane.
   */
  public function testDoesGiftAidSettingsPaneExist() {
    $this->drupalGet('admin/commerce/config/checkout-flows/manage/default');
    $this->assertSession()->pageTextContains($this->t('Gift Aid Declaration'));
  }

}
