<?php

namespace Drupal\Tests\gift_aid_commerce\Kernel;

use Drupal\commerce_order\Entity\Order;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceEvents;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent;
use Drupal\Tests\commerce_order\Kernel\OrderKernelTestBase;
use Drupal\Tests\gift_aid\Traits\GiftAidKernelTestTrait;

/**
 * Tests finding the charity for an order from the store.
 *
 * @coversDefaultClass \Drupal\gift_aid_commerce\EventSubscriber\GiftAidOrderStoreCharitySubscriber
 * @group gift_aid_commerce
 */
class StoreCharityTest extends OrderKernelTestBase {

  use GiftAidKernelTestTrait;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'datetime',
    'dynamic_entity_reference',
    'gift_aid',
    'gift_aid_commerce',
    'options',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->giftAidKernelSetUp();
  }

  /**
   * Tests events and charities for the store.
   */
  public function testEventStoreCharity() {
    // Test the charity can be set on the store.
    $this->assertTrue($this->store->hasField('gift_aid_charity'));
    $this->store->set('gift_aid_charity', $this->charity)->save();
    $this->assertSame($this->charity->id(), $this->store->get('gift_aid_charity')->target_id);

    // Test the event subscriber sets the charity from the store on the event.
    $order = $this->createOrder();
    $event = new GiftAidCommerceOrderInfoEvent($order);
    \Drupal::service('event_dispatcher')->dispatch($event, GiftAidCommerceEvents::ORDER_INFO);
    $this->assertSame($this->charity->id(), $event->getCharity()->id());
  }

  /**
   * Creates an order.
   *
   * @param array $values
   *   Values to set on the order.
   *
   * @return \Drupal\commerce_order\Entity\OrderInterface
   *   The order.
   */
  protected function createOrder(array $values = []) {
    $defaults = [
      'type' => 'default',
      'store_id' => $this->store->id(),
      'state' => 'complete',
    ];
    $values = $values + $defaults;
    $order = Order::create($values);
    $order->save();
    return $order;
  }

}
