<?php

namespace Drupal\gift_aid_commerce_product\EventSubscriber;

use Drupal\commerce_product\Entity\ProductVariationInterface;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceEvents;
use Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber that checks which products are eligible.
 */
class GiftAidOrderProductEligibleSubscriber implements EventSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    $events = [
      GiftAidCommerceEvents::ORDER_INFO => ['setEligibleFromProduct'],
    ];
    return $events;
  }

  /**
   * Specify the order items eligible for Gift Aid, based on their product.
   *
   * @param \Drupal\gift_aid_commerce\Event\GiftAidCommerceOrderInfoEvent $event
   *   The order info event.
   */
  public function setEligibleFromProduct(GiftAidCommerceOrderInfoEvent $event) {
    foreach ($event->getOrder()->getItems() as $item) {
      $purchased = $item->getPurchasedEntity();
      if ($purchased instanceof ProductVariationInterface) {
        $product = $purchased->getProduct();
        if ($product->hasField('gift_aid_eligible')) {
          if ($product->get('gift_aid_eligible')->value) {
            $event->addEligibleItem($item);
          }
        }
      }
    }
  }

}
