<?php

namespace Drupal\gift_aid\Charity;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Charity entity.
 *
 * @see \Drupal\gift_aid\Entity\Charity.
 */
class CharityAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\gift_aid\Entity\CharityInterface $entity */
    switch ($operation) {
      case 'view':
        // No need to restrict viewing of the charity entity.
        return AccessResult::allowed();
    }

    // The parent allows those with the admin permission to do update and delete.
    return parent::checkAccess($entity, $operation, $account);
  }

}
