<?php

namespace Drupal\gift_aid\Charity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Defines a class to build a listing of charities.
 *
 * @ingroup gift_aid
 */
class CharityListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['name'] = $this->t('Name');
    $header['reg_name'] = $this->t('Registered Name');
    $header['default'] = $this->t('Default');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\gift_aid\Entity\Charity $entity */
    $row['name'] = $entity->getName();
    $row['reg_name'] = $entity->getRegisteredName();
    $row['default'] = $entity->isDefault() ? $this->t('Yes') : NULL;
    return $row + parent::buildRow($entity);
  }

}
