<?php

namespace Drupal\gift_aid\Controller;

use Symfony\Component\HttpFoundation\RedirectResponse;
use Drupal\Component\Utility\UrlHelper;
use Drupal\Core\Entity\Controller\EntityController;

/**
 * Controller for gift aid entities.
 */
class DeclarationController extends EntityController {

  /**
   * {@inheritdoc}
   */
  public function addPage($entity_type_id) {
    $build = parent::addPage($entity_type_id);

    if ($donor_id = \Drupal::request()->query->get('donor')) {
      // Propagate the query string to the target URLs.
      $query = ['donor' => $donor_id];

      if ($build instanceof RedirectResponse) {
        $url = $build->getTargetUrl() . '?' . UrlHelper::buildQuery($query);
        $build->setTargetUrl($url);
      }
      else {
        foreach ($build['#bundles'] as &$bundle_info) {
          $url = $bundle_info['add_link']->getUrl();
          $url->mergeOptions(['query' => $query]);
        }
      }
    }

    return $build;
  }

}
