<?php

namespace Drupal\gift_aid\Declaration;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\Sql\SqlContentEntityStorage;
use Drupal\gift_aid\Entity\CharityInterface;

/**
 * Defines the gift aid declaration storage.
 */
class DeclarationStorage extends SqlContentEntityStorage implements DeclarationStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function loadByContext(EntityInterface $context, ?CharityInterface $charity = NULL) {
    $properties = [
      'donor.entity:gift_aid_donor.context.target_type' => $context->getEntityTypeId(),
      'donor.entity:gift_aid_donor.context.target_id' => $context->id(),
    ];

    if ($charity) {
      $properties['charity.target_id'] = $charity->id();
    }

    return $this->loadByProperties($properties);
  }

  /**
   * {@inheritdoc}
   */
  public function loadOngoingByContext(EntityInterface $context, ?CharityInterface $charity = NULL) {
    $declarations = $this->loadByContext($context, $charity);
    return array_filter($declarations, function ($declaration) {
      return $declaration->isOngoing();
    });
  }

  /**
   * {@inheritdoc}
   */
  public function hasOngoingByContext(EntityInterface $context, ?CharityInterface $charity = NULL) {
    return (bool) $this->loadOngoingByContext($context, $charity);
  }

}
