<?php

namespace Drupal\gift_aid\Declaration;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\gift_aid\Entity\CharityInterface;

/**
 * Defines an interface for gift aid declaration storage.
 */
interface DeclarationStorageInterface extends ContentEntityStorageInterface {

  /**
   * Load gift aid declarations for a specific context.
   *
   * Optionally restrict declarations to a specific charity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $context
   *   The entity that is the context to find declarations for.
   * @param \Drupal\gift_aid\Entity\CharityInterface $charity
   *   (optional) The charity to find declarations for.
   *
   * @return \Drupal\gift_aid\Entity\DeclarationInterface[]
   *   An array of gift aid declaration objects indexed by their ids.
   */
  public function loadByContext(EntityInterface $context, ?CharityInterface $charity = NULL);

  /**
   * Load ongoing gift aid declarations for a specific context.
   *
   * @param \Drupal\Core\Entity\EntityInterface $context
   *   The entity that is the context to find declarations for.
   * @param \Drupal\gift_aid\Entity\CharityInterface $charity
   *   (optional) The charity to find declarations for.
   *
   * @return \Drupal\gift_aid\Entity\DeclarationInterface[]
   *   An array of gift aid declaration objects indexed by their ids.
   *
   * @see DeclarationInterface::isOngoing()
   */
  public function loadOngoingByContext(EntityInterface $context, ?CharityInterface $charity = NULL);

  /**
   * Determine whether an ongoing declaration exists for a context and charity.
   *
   * @param \Drupal\Core\Entity\EntityInterface $context
   *   The entity that is the context to find declarations for.
   * @param \Drupal\gift_aid\Entity\CharityInterface $charity
   *   The charity to find declarations for.
   *
   * @return bool
   *   Whether there is an ongoing declaration for this context and charity.
   */
  public function hasOngoingByContext(EntityInterface $context, CharityInterface $charity);

}
