<?php

namespace Drupal\gift_aid\Donor;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Donor entity.
 *
 * @see \Drupal\gift_aid\Entity\Donor.
 */
class DonorAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\gift_aid\Entity\DonorInterface $entity */
    $admin_permission = $this->entityType->getAdminPermission();
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermissions($account, ['view gift aid declarations', $admin_permission], 'OR');

      case 'update':
        return AccessResult::allowedIfHasPermissions($account, ['record gift aid declarations made by others', $admin_permission], 'OR');

      case 'delete':
        // @todo Block if there are declarations.
    }

    return parent::checkAccess($entity, $operation, $account);
  }

  /**
   * {@inheritdoc}
   */
  protected function checkFieldAccess($operation, FieldDefinitionInterface $field_definition, AccountInterface $account, ?FieldItemListInterface $items = NULL) {
    $admin_permission = $this->entityType->getAdminPermission();
    $donor = $items ? $items->getEntity() : NULL;

    switch ($field_definition->getName()) {
      case 'evidence':
      case 'explanation':
      case 'revision_log':
      case 'context':
        return AccessResult::allowedIfHasPermissions($account, ['record gift aid declarations made by others', $admin_permission], 'OR')
          ->addCacheableDependency($donor);
    }

    return parent::checkFieldAccess($operation, $field_definition, $account, $items);
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    $admin_permission = $this->entityType->getAdminPermission();
    return AccessResult::allowedIfHasPermissions($account, ['record gift aid declarations made by others', $admin_permission], 'OR');
  }

}
