<?php

namespace Drupal\gift_aid\Donor;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of donors.
 *
 * @ingroup gift_aid
 */
class DonorListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('ID');
    $header['context'] = $this->t('Context');
    $header['name'] = $this->t('Name');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\gift_aid\Entity\DonorInterface $entity */
    $row['id'] = Link::createFromRoute(
      $entity->id(),
      'entity.gift_aid_donor.canonical',
      ['gift_aid_donor' => $entity->id()]
    );
    $context = $entity->getContext();
    $row['context'] = $context ? $context->toLink()->toString() : NULL;
    $row['name'] = $entity->getAddressName();

    return $row + parent::buildRow($entity);
  }

}
