<?php

namespace Drupal\gift_aid\Donor;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\Sql\SqlContentEntityStorage;

/**
 * Defines the gift aid declaration storage.
 */
class DonorStorage extends SqlContentEntityStorage implements DonorStorageInterface {

  /**
   * {@inheritdoc}
   */
  public function loadOrCreateByContext(EntityInterface $context) {
    $properties = [
      'context.target_type' => $context->getEntityTypeId(),
      'context.target_id' => $context->id(),
    ];
    if ($result = $this->loadByProperties($properties)) {
      return reset($result);
    }

    /** @var \Drupal\gift_aid\Entity\DonorInterface $donor */
    $donor = $this->create();
    $donor->setContext($context);
    return $donor;
  }

}
