<?php

namespace Drupal\gift_aid\Donor;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Entity\EntityInterface;

/**
 * Defines an interface for gift aid declaration storage.
 */
interface DonorStorageInterface extends ContentEntityStorageInterface {

  /**
   * Load or create a donor for a specific context.
   *
   * @param \Drupal\Core\Entity\EntityInterface $context
   *   The entity that is the context to find declarations for.
   *
   * @return \Drupal\gift_aid\Entity\DonorInterface
   *   The donor.
   */
  public function loadOrCreateByContext(EntityInterface $context);

}
