<?php

namespace Drupal\gift_aid\Donor;

use Drupal\Core\Entity\EntityViewBuilder;
use Drupal\Core\Url;

/**
 * View builder handler for the Donor entity.
 */
class DonorViewBuilder extends EntityViewBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildComponents(array &$build, array $entities, array $displays, $view_mode) {
    parent::buildComponents($build, $entities, $displays, $view_mode);

    $current_user = \Drupal::currentUser();
    $entity_type_manager = \Drupal::entityTypeManager();

    foreach ($entities as $id => $donor) {
      $display = $displays['gift_aid_donor'];
      $actions = [];

      if ($donor->id()) {
        $actions['declare'] = [
          '#theme' => 'menu_local_action',
          '#link' => [
            'title' => $this->t('Add Declaration'),
            'url' => Url::fromRoute('entity.gift_aid_declaration.add_page', [], ['query' => ['donor' => $donor->id()]]),
          ],
          '#access' => $current_user->hasPermission('record gift aid declarations made by others'),
        ];

        $actions['cancel'] = [
          '#theme' => 'menu_local_action',
          '#link' => [
            'title' => $this->t('Cancel'),
            'url' => Url::fromRoute('entity.gift_aid_cancellation.add_form', [], ['query' => ['donor' => $donor->id()]]),
          ],
          '#access' => $current_user->hasPermission('record gift aid declarations made by others'),
        ];

        $actions['edit'] = [
          '#theme' => 'menu_local_action',
          '#link' => [
            'title' => $this->t('Edit'),
            'url' => Url::fromRoute('entity.gift_aid_donor.edit_form', ['gift_aid_donor' => $donor->id()]),
          ],
          '#access' => $donor->access('update'),
        ];
      }

      if ($actions) {
        $build[$id]['actions'] = [
          '#prefix' => '<ul class="action-links">',
          '#suffix' => '</ul>',
          '#weight' => -10,
        ] + $actions;
      }

      if ($display->getComponent('status')) {
        $build[$id]['status'] = [
          '#type' => 'item',
          '#title' => $this->t('Status'),
          '#markup' => $donor->getStatusString(),
        ];
      }

      if ($display->getComponent('declarations')) {
        $builder = $entity_type_manager->getListBuilder('gift_aid_declaration');
        $builder->setEntities($donor->getDeclarations());
        $build[$id]['declarations'] = [
          '#type' => 'fieldset',
          '#title' => $this->t('Declarations'),
          'list' => $builder->render(),
          '#access' => \Drupal::currentUser()->hasPermission('record gift aid declarations made by others'),
        ];
      }

      if ($display->getComponent('cancellations')) {
        $builder = $entity_type_manager->getListBuilder('gift_aid_cancellation');
        $builder->setEntities($donor->getCancellations());
        $build[$id]['cancellations'] = [
          '#type' => 'fieldset',
          '#title' => $this->t('Cancellations'),
          'list' => $builder->render(),
          '#access' => \Drupal::currentUser()->hasPermission('record gift aid declarations made by others'),
        ];
      }
    }
  }

}
