<?php

namespace Drupal\gift_aid\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Declaration type entity.
 *
 * @ConfigEntityType(
 *   id = "gift_aid_declaration_type",
 *   label = @Translation("Declaration type"),
 *   label_collection = @Translation("Declaration types"),
 *   handlers = {
 *     "access" = "Drupal\gift_aid\Declaration\DeclarationTypeAccessControlHandler",
 *     "list_builder" = "Drupal\gift_aid\Declaration\DeclarationTypeListBuilder",
 *     "form" = {
 *       "default" = "Drupal\gift_aid\Form\Declaration\DeclarationTypeForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "gift_aid_declaration_type",
 *   admin_permission = "configure gift aid",
 *   bundle_of = "gift_aid_declaration",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "description" = "description",
 *   },
 *   links = {
 *     "add-form" = "/admin/gift-aid/declaration-type/add",
 *     "edit-form" = "/admin/gift-aid/declaration-type/{gift_aid_declaration_type}/edit",
 *     "delete-form" = "/admin/gift-aid/declaration-type/{gift_aid_declaration_type}/delete",
 *     "collection" = "/admin/gift-aid/declaration-type"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *     "method",
 *   }
 * )
 */
class DeclarationType extends ConfigEntityBundleBase implements DeclarationTypeInterface {

  /**
   * The declaration type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The declaration type label.
   *
   * @var string
   */
  protected $label;

  /**
   * The description of the declaration type.
   *
   * @var string|null
   */
  protected $description = NULL;

  /**
   * The method.
   *
   * @var string
   */
  protected $method;

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->description ?? '';
  }

  /**
   * {@inheritdoc}
   */
  public function setDescription($description) {
    return $this->set('description', $description);
  }

  /**
   * {@inheritdoc}
   */
  public function getMethod() {
    return $this->method;
  }

  /**
   * {@inheritdoc}
   */
  public function shouldCreateNewRevision() {
    return TRUE;
  }

}
