<?php

namespace Drupal\gift_aid\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;
use Drupal\Core\Entity\RevisionableEntityBundleInterface;

/**
 * Provides an interface for defining Declaration type entities.
 */
interface DeclarationTypeInterface extends ConfigEntityInterface, EntityDescriptionInterface, RevisionableEntityBundleInterface {

  // @todo document significance of the methods.
  const METHOD_ORAL = 'oral';
  const METHOD_WRITTEN = 'written';
  const METHOD_WEB = 'web';

  /**
   * Returns the method.
   *
   * @return string
   *   One of the METHOD_ constants.
   */
  public function getMethod();

}
