<?php

namespace Drupal\gift_aid\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\gift_aid\EntityValidationTrait;

/**
 * Defines the Evidence entity.
 *
 * @ingroup gift_aid
 *
 * @ContentEntityType(
 *   id = "gift_aid_evidence",
 *   label = @Translation("Gift Aid evidence"),
 *   label_collection = @Translation("Gift Aid evidence"),
 *   label_singular = @Translation("Gift Aid evidence"),
 *   label_plural = @Translation("Gift Aid evidence"),
 *   label_count = @PluralTranslation(
 *     singular = "@count Gift Aid evidence",
 *     plural = "@count Gift Aid evidence"
 *   ),
 *   bundle_label = @Translation("Evidence type"),
 *   handlers = {
 *     "form" = {
 *       "default" = "Drupal\gift_aid\Form\Evidence\EvidenceForm",
 *       "add" = "Drupal\gift_aid\Form\Evidence\EvidenceForm",
 *       "edit" = "Drupal\gift_aid\Form\Evidence\EvidenceForm",
 *       "delete" = "Drupal\gift_aid\Form\GiftAidDeleteForm",
 *     },
 *     "access" = "Drupal\gift_aid\Evidence\EvidenceAccessControlHandler",
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider",
 *     },
 *   },
 *   base_table = "gift_aid_evidence",
 *   data_table = "gift_aid_evidence_field_data",
 *   admin_permission = "administer gift aid declarations",
 *   entity_keys = {
 *     "id" = "id",
 *     "bundle" = "type",
 *     "uuid" = "uuid",
 *   },
 *   links = {
 *     "canonical" = "/admin/gift-aid/evidence/{gift_aid_evidence}",
 *     "add-page" = "/admin/gift-aid/evidence/add",
 *     "add-form" = "/admin/gift-aid/evidence/add/{gift_aid_evidence_type}",
 *     "edit-form" = "/admin/gift-aid/evidence/{gift_aid_evidence}/edit",
 *     "delete-form" = "/admin/gift-aid/evidence/{gift_aid_evidence}/delete",
 *   },
 *   bundle_entity_type = "gift_aid_evidence_type",
 *   field_ui_base_route = "entity.gift_aid_evidence_type.edit_form",
 * )
 */
class Evidence extends ContentEntityBase implements EvidenceInterface {

  use EntityValidationTrait;

}
