<?php

namespace Drupal\gift_aid\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Evidence type entity.
 *
 * @ConfigEntityType(
 *   id = "gift_aid_evidence_type",
 *   label = @Translation("Evidence type"),
 *   label_collection = @Translation("Evidence types"),
 *   handlers = {
 *     "access" = "Drupal\gift_aid\Evidence\EvidenceTypeAccessControlHandler",
 *     "list_builder" = "Drupal\gift_aid\Evidence\EvidenceTypeListBuilder",
 *     "form" = {
 *       "default" = "Drupal\gift_aid\Form\Evidence\EvidenceTypeForm",
 *       "delete" = "Drupal\gift_aid\Form\Evidence\EvidenceTypeDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   config_prefix = "gift_aid_evidence_type",
 *   admin_permission = "configure gift aid",
 *   bundle_of = "gift_aid_evidence",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "description" = "description",
 *   },
 *   links = {
 *     "add-form" = "/admin/gift-aid/evidence-type/add",
 *     "edit-form" = "/admin/gift-aid/evidence-type/{gift_aid_evidence_type}/edit",
 *     "delete-form" = "/admin/gift-aid/evidence-type/{gift_aid_evidence_type}/delete",
 *     "collection" = "/admin/gift-aid/evidence-type"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "description",
 *     "internal",
 *   }
 * )
 */
class EvidenceType extends ConfigEntityBundleBase implements EvidenceTypeInterface {

  /**
   * The evidence type ID.
   *
   * @var string
   */
  protected $id;

  /**
   * The evidence type label.
   *
   * @var string
   */
  protected $label;

  /**
   * The description of the evidence type.
   *
   * @var string|null
   */
  protected $description = NULL;

  /**
   * Whether this type is for internal (programmatic) use only.
   */
  protected bool $internal = FALSE;

  /**
   * {@inheritdoc}
   */
  public function getDescription() {
    return $this->description ?? '';
  }

  /**
   * Gets whether this is an internal evidence type.
   *
   * @return bool
   *   TRUE if this is an internal evidence type. for programmatic use only.
   */
  public function isInternal() {
    return $this->internal;
  }

}
