<?php

namespace Drupal\gift_aid;

use Drupal\Core\Entity\EntityStorageInterface;
use Symfony\Component\Validator\ConstraintViolation;

/**
 * Trait for content entities requiring validation prior to save.
 */
trait EntityValidationTrait {

  /**
   * Pre-save method for performing validation.
   *
   * @param \Drupal\Core\Entity\EntityStorageInterface $storage
   *   Entity storage.
   */
  public function preSave(EntityStorageInterface $storage): void {
    if (!$this->validated) {
      $validation = $this->validate();
      if (count($validation) > 0) {
        $message = sprintf(
          '%s failed validation: %s',
          $this->getEntityType()->getLabel(),
          implode(', ', array_map(
            fn (ConstraintViolation $violation) => $violation->getPropertyPath() . ": " . $violation->getMessage(),
            iterator_to_array($validation)
          ))
        );
        throw new \LogicException($message);
      }
    }
    parent::preSave($storage);
  }

}
