<?php

namespace Drupal\gift_aid\Event;

/**
 * The names of events used by the Gift Aid module.
 */
final class GiftAidEvents {

  /**
   * The name of the event fired when finding related gift aid contexts.
   *
   * This event allows you to add additional contexts related to the any contexts discovered so far.
   * The event listener method receives a
   * \Drupal\gift_aid\GiftAidRelatedContextsEvent instance.
   *
   * @Event
   *
   * @see \Drupal\gift_aid\Event\GiftAidRelatedContextsEvent
   */
  const RELATED_CONTEXTS = 'gift_aid.related_contexts';

}
