<?php

namespace Drupal\gift_aid\Evidence;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Evidence entity.
 *
 * @see \Drupal\gift_aid\Entity\Evidence.
 */
class EvidenceAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\gift_aid\Entity\EvidenceInterface $entity */
    $admin_permission = $this->entityType->getAdminPermission();
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermissions($account, ['view gift aid declarations', $admin_permission], 'OR');

      case 'update':
        // Direct editing is not allowed - upload new evidence instead.
        return AccessResult::forbidden();

      case 'delete':
        // Fallback to admin permission in parent method.
    }

    return parent::checkAccess($entity, $operation, $account);
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    $type = \Drupal::entityTypeManager()->getStorage($this->entityType->getBundleEntityType())->load($entity_bundle);
    if ($type->isInternal()) {
      return AccessResult::forbidden()->addCacheableDependency($type);
    }

    $admin_permission = $this->entityType->getAdminPermission();
    return AccessResult::allowedIfHasPermissions($account, ['record gift aid declarations made by others', $admin_permission], 'OR');
  }

}
