<?php

namespace Drupal\gift_aid\Evidence;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the evidence type entity type.
 */
class EvidenceTypeAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'update':
      case 'delete':
        if ($entity->isInternal()) {
          return AccessResult::forbidden()->addCacheableDependency($entity);
        }
        break;
    }
    return parent::checkAccess($entity, $operation, $account);
  }

}
