<?php

namespace Drupal\gift_aid\Form\Charity;

use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a form for deleting charities.
 *
 * @ingroup gift_aid
 */
class CharityDeleteForm extends ContentEntityDeleteForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $declarations_count = $this->entityTypeManager->getStorage('gift_aid_declaration')->getQuery()
      ->accessCheck(FALSE)
      ->condition('charity', $this->entity->id())
      ->count()
      ->execute();
    if ($declarations_count) {
      $caption = '<p>' . $this->formatPlural($declarations_count, '%label has a Gift Aid declaration on your site. You can not remove this charity until you have removed all of the declarations for it.', '%label has @count Gift Aid declarations on your site. You may not remove %label until you have removed the declaration for it.', ['%label' => $this->entity->label()]) . '</p>';
      $form['description'] = ['#markup' => $caption];
      return $form;
    }
    else {
      return parent::buildForm($form, $form_state);
    }
  }

}
